# Changelog

All notable changes to this project will be documented in this file, in reverse chronological order by release.

## 3.4.1 - 2019-12-10

### Added

- [zendframework/zend-code#180](https://github.com/zendframework/zend-code/pull/180) adds support for PHP 7.4.

### Changed

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#179](https://github.com/zendframework/zend-code/pull/179) fixes exception message when invalid value provided in `Laminas\Code\Generator\ValueGenerator`.

- [zendframework/zend-code#180](https://github.com/zendframework/zend-code/pull/190) fixes PHP 7.4 compatibility.

## 3.4.0 - 2019-10-06

### Added

- [zendframework/zend-code#170](https://github.com/zendframework/zend-code/pull/170) adds class constant visibility modifiers support.

- [zendframework/zend-code#169](https://github.com/zendframework/zend-code/pull/169) adds the ability to define declare statements.

- [zendframework/zend-code#167](https://github.com/zendframework/zend-code/pull/167) adds the ability to remove doc block of a member.

### Changed

- [zendframework/zend-code#166](https://github.com/zendframework/zend-code/pull/166) changes omitting default property value if it is null.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#172](https://github.com/zendframework/zend-code/pull/172) fixes PHP 7.4 compatibility.

## 3.3.2 - 2019-08-31

### Added

- [zendframework/zend-code#162](https://github.com/zendframework/zend-code/pull/162) adds support for PHP 7.3.

### Changed

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#171](https://github.com/zendframework/zend-code/pull/171) changes
  curly braces in array and string offset access to square brackets
  in order to prevent issues under the upcoming PHP 7.4 release.

- [zendframework/zend-code#164](https://github.com/zendframework/zend-code/pull/164) fixes indentation in multi-level arrays generated by `ValueGenerator`.

## 3.3.1 - 2018-08-13

### Added

- Nothing.

### Changed

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#158](https://github.com/zendframework/zend-code/pull/158) updates several `switch` cases to use `break` instead of `continue`
  in order to prevent issues under the upcoming PHP 7.3 release.

- [zendframework/zend-code#147](https://github.com/zendframework/zend-code/pull/147) fixes the regular expression used for `@var` annotations to
  allow omission of the variable name.

- [zendframework/zend-code#146](https://github.com/zendframework/zend-code/pull/146) updates all `@return` annotations to reflect the correct types returned by each method.

- [zendframework/zend-code#144](https://github.com/zendframework/zend-code/pull/144) fixes the class generator such that it now resolves
  `setExtendedClass()` arguments to aliases provided to the generator.

- [zendframework/zend-code#140](https://github.com/zendframework/zend-code/pull/140) fixes `MethodScanner::setVisibility()` such that it no longer
  casts the provided visibility token to lower case; this fix is necessary, as
  the method is supposed to expect only the appropriate
  `T_(PUBLIC|PROTECTED|PRIVATE)` token values, which are integers.

- [zendframework/zend-code#140](https://github.com/zendframework/zend-code/pull/140) updates the `MethodScanner::setVisibility()` method to raise
  a package-specific `InvalidArgumentException` instead of the non-existent
  package `Exception` class when an invalid visibility is provided.

## 3.3.0 - 2017-10-20

### Added

- [zendframework/zend-code#131](https://github.com/zendframework/zend-code/pull/131) added the
  ability to omit a parameter type declaration
- [zendframework/zend-code#132](https://github.com/zendframework/zend-code/pull/132) added a
  lightweight `MethodGenerator::copyMethodSignature()` constructor that
  only copies the method declaration with no body nor docblock.
- [zendframework/zend-code#134](https://github.com/zendframework/zend-code/pull/134) short array
  notation is now used by default for generated array values
- [zendframework/zend-code#136](https://github.com/zendframework/zend-code/pull/136) added the
  ability to specify an `omitdefaultvalue` key when using
  `ParameterGenerator::fromArray()`

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#130](https://github.com/zendframework/zend-code/pull/130) Updated 
  links to the documentation
- [zendframework/zend-code#133](https://github.com/zendframework/zend-code/pull/133) The default
  value of a `ParameterGenerator` is always a `ValueGenerator`

## 3.2.0 - 2017-07-23

### Added

- [zendframework/zend-code#112](https://github.com/zendframework/zend-code/pull/112)
  [zendframework/zend-code#110](https://github.com/zendframework/zend-code/pull/110) Introduced
  support for the PHP `7.2` `object` type-hint
- [zendframework/zend-code#41](https://github.com/zendframework/zend-code/pull/41) Added `VarTag`
  support to the docblock generators and reflectors: allows generating
  and parsing `@var` tags.
- [zendframework/zend-code#113](https://github.com/zendframework/zend-code/pull/113) Added
  PHP `7.2` to the build matrix
- [zendframework/zend-code#114](https://github.com/zendframework/zend-code/pull/114) Increased
  minimum supported PHP version to `^7.1.0`
- [zendframework/zend-code#114](https://github.com/zendframework/zend-code/pull/114) Upgraded
  PHPUnit dependency to `^6.2.2`
- [zendframework/zend-code#121](https://github.com/zendframework/zend-code/pull/121) Imported
  global functions via `use` statements (experimenting with OpCache
  OPCODE inlining optimisations)

### Deprecated

- Nothing.

### Removed

- [zendframework/zend-code#113](https://github.com/zendframework/zend-code/pull/113)
  [zendframework/zend-code#118](https://github.com/zendframework/zend-code/pull/118) Removed
  HHVM support
- [zendframework/zend-code#122](https://github.com/zendframework/zend-code/pull/122) Removed
  IRC notifications for pushes/build statuses

### Fixed

- [zendframework/zend-code#101](https://github.com/zendframework/zend-code/pull/101) avoid
  calling `isInternalPhpType` twice in the `TypeGenerator`
- [zendframework/zend-code#115](https://github.com/zendframework/zend-code/pull/115) Replaced
  assertions in the test suite with their static counterparts where
  applicable
- [zendframework/zend-code#120](https://github.com/zendframework/zend-code/pull/120)
  [zendframework/zend-code#109](https://github.com/zendframework/zend-code/pull/109)
  [zendframework/zend-code#100](https://github.com/zendframework/zend-code/pull/100) Applied
  Laminas coding standard to the library code
- [zendframework/zend-code#119](https://github.com/zendframework/zend-code/pull/119) Corrected
  test suite errors caused by mismatching parameter order
- [zendframework/zend-code#106](https://github.com/zendframework/zend-code/pull/106)
- [zendframework/zend-code#107](https://github.com/zendframework/zend-code/pull/107) Minor
  typing error corrections in documentation and error messages

## 3.1.0 - 2016-10-24

### Added

- [zendframework/zend-code#87](https://github.com/zendframework/zend-code/pull/87) support for
  PHP 7.1's `void` return type declaration.
- [zendframework/zend-code#87](https://github.com/zendframework/zend-code/pull/87) support for
  PHP 7.1's nullable type declarations.
- [zendframework/zend-code#87](https://github.com/zendframework/zend-code/pull/87) support for
  PHP 7.1's `iterable` type declaration.
- [zendframework/zend-code#62](https://github.com/zendframework/zend-code/pull/62) added
  `Laminas\Code\Generator\MethodGenerator#getReturnType()` accessor.
- [zendframework/zend-code#68](https://github.com/zendframework/zend-code/pull/68)
  [zendframework/zend-code#26](https://github.com/zendframework/zend-code/pull/26) added mutators
  to allow removing/checking for existence of methods, properties, constants,
  parameters and type declarations across all the code generator API.
- [zendframework/zend-code#65](https://github.com/zendframework/zend-code/pull/65) continuous
  integration testing now checks locked, newest and oldest dependency
  sets.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- Nothing.

## 3.0.5 - 2016-10-24

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#92](https://github.com/zendframework/zend-code/pull/92) corrected
  `Laminas\Code\Scanner\ClassScanner` to detect multiple interface inheritance.
- [zendframework/zend-code#95](https://github.com/zendframework/zend-code/pull/95) corrected
  `Laminas\Code\Generator\ParameterGenerator` to allow copying parameter signatures
  for non-optional parameters that are still nullable via a default `= null`
  value.
- [zendframework/zend-code#94](https://github.com/zendframework/zend-code/pull/94) corrected
  `Laminas\Code\Generator\ValueGenerator` so that class constants can now
  be generated with arrays as default value (supported since PHP 5.6).

## 3.0.4 - 2016-06-30

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#59](https://github.com/zendframework/zend-code/pull/59) fixes an issue with
  detection of multiple trait `use` statements.
- [zendframework/zend-code#75](https://github.com/zendframework/zend-code/pull/75) provides a patch to
  ensure that `extends` statements qualify the parent class based on the current
  namespace and/or import statements.

## 3.0.3 - 2016-06-27

### Added

- [zendframework/zend-code#66](https://github.com/zendframework/zend-code/pull/66) publishes the
  documentation to https://docs.laminas.dev/laminas-code/.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#61](https://github.com/zendframework/zend-code/pull/61) fixes an issue with
  how parameter typehints were generated; previously, fully-qualified class
  names were not being generated with the leading backslash, causing them to
  attempt to resolve as if they were relative to the current namespace.
- [zendframework/zend-code#69](https://github.com/zendframework/zend-code/pull/69) fixes an issue with
  how class names under the same namespace are generated when generating
  typehints, extends, and implements values; they now strip the
  common namespace from the class name.
- [zendframework/zend-code#72](https://github.com/zendframework/zend-code/pull/72) fixes an issue
  within the `TokenArrayScanner` when scanning closures.

## 3.0.2 - 2016-04-20

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#52](https://github.com/zendframework/zend-code/pull/52) updates several
  dependency constraints:
  - laminas-stdlib now allows either the 2.7 or 3.0 series, as the APIs consumed by
    laminas-code are compatible across versions.
  - PHP now excludes the 7.0.5 release, as it has known issues in its tokenizer
    implementation that make the laminas-code token scanner unusable.
- [zendframework/zend-code#46](https://github.com/zendframework/zend-code/pull/46) updates all
  generators to use `\n` for line endings in generated code, vs `PHP_EOL`,
  ensuring cross-platform consistency.

## 3.0.1 - 2016-01-26

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#34](https://github.com/zendframework/zend-code/pull/34) method name cannot be optional when adding a method
  to a class generator.
- [zendframework/zend-code#38](https://github.com/zendframework/zend-code/pull/38) PHP_CodeSniffer was moved to dev dependencies

## 3.0.0 - 2016-01-13

### Changed

- [zendframework/zend-code#140](https://github.com/zendframework/zend-code/pull/140) updates the `MethodScanner::setVisibility()` method to raise a package-specific `InvalidArgumentException` instead of
  the non-existent package `Exception` class when an invalid visibility is provided.

This section refers to breaking changes: please refer to
[docs/book/migration.md](docs/book/migration.md) for migration instructions.

- Types `string`, `int`, `float`, `bool` passed to `Laminas\Code\Generator\ParameterGenerator#setType()`
  are no longer ignored in generated code [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- Types declared in DocBlocks are now ignored when creating a `Laminas\Code\Generator\ParameterGenerator` via
  `Laminas\Code\Generator\ParameterGenerator::fromReflection()`. [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- Type strings are now validated: passing an invalid type to any method in the generator API
  may lead to a `Laminas\Code\Generator\InvalidArgumentException` being thrown.
  [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- `Laminas\Code\Generator\ParameterGenerator::$simple` was removed. [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- `Laminas\Code\Generator\ParameterGenerator#$type` is now a `null|Laminas\Code\Generator\TypeGenerator`: was a
  `string` before. [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- `Laminas\Code\Generator` type-hints are now always prefixed with the namespace separator `\`.
  [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- `Laminas\Code\Reflection\ParameterReflection#getType()` was renamed 
  to `Laminas\Code\Reflection\ParameterReflection#detectType()` in order to not override the inherited
  `ReflectionParameter#getType()`, introduced in PHP 7. [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)

### Added

- PHP 7 return type hints generation support via `Laminas\Code\Generator\MethodGenerator#setReturnType()`.
  [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- PHP 7 scalar type hints generation support via `Laminas\Code\Generator\ParameterGenerator#setType()` and 
  `Laminas\Code\Generator\ParameterGenerator#getType()`. [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- PHP 5.6 variadic arguments support via `Laminas\Code\Generator\ParameterGenerator#setVariadic()` and
  `Laminas\Code\Generator\ParameterGenerator#getVariadic()`. [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)
- Generation of methods returning by reference is supported via `Laminas\Code\Generator\ParameterGenerator#setReturnsReference()`.
  [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)

### Deprecated

- Nothing.

### Removed

- `Laminas\Code\ParameterGenerator::$simple` was removed. [zendframework/zend-code#30](https://github.com/zendframework/zend-code/pull/30)

### Fixed

- Nothing.

## 2.6.2 - 2015-01-05

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#31](https://github.com/zendframework/zend-code/pull/31) updated license year.

## 2.6.2 - 2015-01-05

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#31](https://github.com/zendframework/zend-code/pull/31) updated license year.

## 2.6.1 - 2015-11-24

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#25](https://github.com/zendframework/zend-code/pull/25) changes the
  `doctrine/common` suggestion/dev-dependency to the more specific
  `doctrine/annotations` package (which is what is actually consumed).

## 2.6.0 - 2015-11-18

### Added

- [zendframework/zend-code#12](https://github.com/zendframework/zend-code/pull/12) adds the ability to
  generate arrays using either long/standard syntax (`array(...)`) or short
  syntax (`[...]`). This can be accomplished by setting the value type to
  `ValueGenerator::TYPE_ARRAY_SHORT` instead of using `TYPE_ARRAY`.
  Additionally, you can use `TYPE_ARRAY_LONG` instead of `TYPE_ARRAY`; the two
  constants are synonyms.
- [zendframework/zend-code#11](https://github.com/zendframework/zend-code/pull/11) adds the ability to
  generate interfaces via the new class `Laminas\Code\Generator\InterfaceGenerator`.

### Deprecated

- Nothing.

### Removed

- Nothing.

### Fixed

- [zendframework/zend-code#20](https://github.com/zendframework/zend-code/pull/20) updates
  the laminas-eventmanager dependency to `^2.6|^3.0`, and changes its
  internal usage to use the `triggerEventUntil()` signature.

## 2.5.3 - 2015-11-18

### Added

- Nothing.

### Deprecated

- Nothing.

### Removed

- [zendframework/zend-code#10](https://github.com/zendframework/zend-code/pull/10) removes a
  development dependency on zendframework/zend-version.
- [zendframework/zend-code#23](https://github.com/zendframework/zend-code/pull/23) removes a
  requirement on laminas/laminas-stdlib. This results in a slight change in
  `Laminas\Code\Generator\ValueGenerator`: `setConstants()` and `getConstants()`
  can now receive/emit *either* an SPL `ArrayObject` or
  `Laminas\Stdlib\ArrayObject`. Since these are functionally equivalent, however,
  you will experience no change in behavior.

### Fixed

- Nothing.
