<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'salesagility/suitecrm';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'api-platform/core' => 'v2.6.7@8a19950a816ccd7cbf38323addbba72b14ac2372',
  'beberlei/assert' => 'v3.3.2@cb70015c04be1baee6f5f5c953703347c0ac1655',
  'behat/transliterator' => 'v1.3.0@3c4ec1d77c3d05caa1f0bf8fb3aae4845005c7fc',
  'composer/package-versions-deprecated' => '1.11.99.3@fff576ac850c045158a250e7e27666e146e78d18',
  'defuse/php-encryption' => 'v2.3.1@77880488b9954b7884c25555c2a0ea9e7053f9d2',
  'doctrine/annotations' => '1.13.2@5b668aef16090008790395c02c893b1ba13f7e08',
  'doctrine/cache' => '1.12.1@4cf401d14df219fa6f38b671f5493449151c9ad8',
  'doctrine/collections' => '1.6.8@1958a744696c6bb3bb0d28db2611dc11610e78af',
  'doctrine/common' => '3.2.1@e927fc2410c8723d053b8032e591cdff76587cdb',
  'doctrine/dbal' => '2.13.6@67ef6d0327ccbab1202b39e0222977a47ed3ef2f',
  'doctrine/deprecations' => 'v0.5.3@9504165960a1f83cc1480e2be1dd0a0478561314',
  'doctrine/doctrine-bundle' => '2.5.4@f6191c50600bad1c0195638413f53aee6158b909',
  'doctrine/doctrine-migrations-bundle' => '3.0.3@0a9a4ffdb8713d0b7f2bbc04b0bbfa2991b2a238',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'doctrine/inflector' => '1.4.4@4bd5c1cdfcd00e9e2d8c484f79150f67e5d355d9',
  'doctrine/instantiator' => '1.4.0@d56bf6102915de5702778fe20f2de3b2fe570b5b',
  'doctrine/lexer' => '1.2.1@e864bbf5904cb8f5bb334f99209b48018522f042',
  'doctrine/migrations' => '3.0.4@0e37888c726f18e2691428128cdeebda5e23fe24',
  'doctrine/orm' => '2.10.4@cccb2e2fdfed2969afb3d65c5ea82bafdefbe1a7',
  'doctrine/persistence' => '2.2.3@5e7bdbbfe9811c06e1f745d1c166647d5c47d6ee',
  'doctrine/sql-formatter' => '1.1.2@20c39c2de286a9d3262cc8ed282a4ae60e265894',
  'elasticsearch/elasticsearch' => 'v7.16.0@f87f93f71f564d4bbdc5f008d296d1c37d828e10',
  'ezimuel/guzzlestreams' => '3.0.1@abe3791d231167f14eb80d413420d1eab91163a8',
  'ezimuel/ringphp' => '1.2.0@92b8161404ab1ad84059ebed41d9f757e897ce74',
  'ezyang/htmlpurifier' => 'v4.14.0@12ab42bd6e742c70c0a52f7b82477fcd44e64b75',
  'fig/link-util' => '1.1.2@5d7b8d04ed3393b4b59968ca1e906fb7186d81e8',
  'firebase/php-jwt' => 'v5.5.1@83b609028194aa042ea33b5af2d41a7427de80e6',
  'friendsofphp/proxy-manager-lts' => 'v1.0.5@006aa5d32f887a4db4353b13b5b5095613e0611f',
  'google/apiclient' => 'v2.12.1@1530583a711f4414407112c4068464bcbace1c71',
  'google/apiclient-services' => 'v0.228.0@ec64bbf1d6af9475bee7b1ce4fc0ed8a0a8d8889',
  'google/auth' => 'v1.18.0@21dd478e77b0634ed9e3a68613f74ed250ca9347',
  'google/recaptcha' => '1.2.4@614f25a9038be4f3f2da7cbfd778dc5b357d2419',
  'guzzlehttp/guzzle' => '7.4.1@ee0a041b1760e6a53d2a39c8c34115adc2af2c79',
  'guzzlehttp/promises' => '1.5.1@fe752aedc9fd8fcca3fe7ad05d419d32998a06da',
  'guzzlehttp/psr7' => '2.1.0@089edd38f5b8abba6cb01567c2a8aaa47cec4c72',
  'gymadarasz/ace' => 'v1.2.3.stable@b42c59125a1ad073a0af9955812d9811814030ec',
  'gymadarasz/imagesloaded' => 'v4.1.01@d156434a1cfab807961aca8497ee84a5bc249253',
  'jeremykendall/php-domain-parser' => '4.0.3-alpha@026a459bb2d32b0352731b5cb525f2c1d2b9d673',
  'jeroendesloovere/vcard' => 'v1.7.3@2b8b6190c613d368b8cb6552e59cf6e6e7d0aea9',
  'justinrainbow/json-schema' => '5.2.11@2ab6744b7296ded80f8cc4f9509abbff393399aa',
  'laminas/laminas-code' => '3.4.1@1cb8f203389ab1482bf89c0e70a04849bacd7766',
  'laminas/laminas-eventmanager' => '3.4.0@a93fd278c97b2d41ebbce5ba048a24e3e6f580ba',
  'laminas/laminas-zendframework-bridge' => '1.4.1@88bf037259869891afce6504cacc4f8a07b24d0f',
  'lcobucci/jwt' => '3.3.3@c1123697f6a2ec29162b82f170dd4a491f524773',
  'league/event' => '2.2.0@d2cc124cf9a3fab2bb4ff963307f60361ce4d119',
  'league/oauth2-server' => '5.1.6@a1a6cb7b4c7e61b5d2b40384c520b72f192d07c4',
  'league/uri' => '4.2.3@e7a31846c3f00c190bd2817a36e943c22a1e2512',
  'monolog/monolog' => '1.26.1@c6b00f05152ae2c9b04a448f99c7590beb6042f5',
  'nelmio/cors-bundle' => '2.2.0@0ee5ee30b0ee08ea122d431ae6e0ddeb87f035c0',
  'nesbot/carbon' => '2.55.2@8c2a18ce3e67c34efc1b29f64fe61304368259a2',
  'nikic/fast-route' => 'v1.3.0@181d480e08d9476e61381e04a71b34dc0432e812',
  'nikolaposa/version' => '4.1.0@0aada6b801962c084ae465f7569397dc2186b6a7',
  'onelogin/php-saml' => '3.4.1@5fbf3486704ac9835b68184023ab54862c95f213',
  'paragonie/constant_time_encoding' => 'v2.4.0@f34c2b11eb9d2c9318e13540a1dbc2a3afbd939c',
  'paragonie/random_compat' => 'v2.0.20@0f1f60250fccffeaf5dda91eea1c018aed1adc2a',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '5.3.0@622548b623e81ca6d78b721c5e029f4ce664f170',
  'phpdocumentor/type-resolver' => '1.5.1@a12f7e301eb7258bb68acd89d4aefa05c2906cae',
  'phpmailer/phpmailer' => 'v6.5.3@baeb7cde6b60b1286912690ab0693c7789a31e71',
  'phpoption/phpoption' => '1.8.1@eab7a0df01fe2344d172bff4cd6dbd3f8b84ad15',
  'phpseclib/phpseclib' => '3.0.12@89bfb45bd8b1abc3b37e910d57f5dbd3174f40fb',
  'pimple/pimple' => 'v3.5.0@a94b3a4db7fb774b3d78dad2315ddc07629e1bed',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.1@8622567409010282b7aeebe4bb841fe98b58dcaf',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.1@2dfb5f6c5eff0e91e20e913f8c5452ed95b86621',
  'psr/http-factory' => '1.0.1@12ac7fcd07e5b077433f5f2bee95b3a771bf61be',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'react/promise' => 'v2.8.0@f3cff96a19736714524ca0dd1d4130de73dbbbc4',
  'robrichards/xmlseclibs' => '3.1.1@f8f19e58f26cdb42c54b214ff8a820760292f8df',
  'shivas/versioning-bundle' => '4.0.0@3654392b9f9d7fb4f70f9d98ec4f4304208ca6e5',
  'slim/slim' => '3.12.3@1c9318a84ffb890900901136d620b4f03a59da38',
  'smarty/smarty' => 'v2.6.33@533fa2abe308dcc009c7bdab977d530b32408346',
  'soundasleep/html2text' => '0.5.0@cdb89f6ffa2c4cc78f8ed9ea6ee0594a9133ccad',
  'symfony/asset' => 'v5.2.12@abe64fee9fa2978c730c84d0d6df760f2d9ddba0',
  'symfony/cache' => 'v5.4.2@8aad4b69a10c5c51ab54672e78995860f5e447ec',
  'symfony/cache-contracts' => 'v2.5.0@ac2e168102a2e06a2624f0379bde94cd5854ced2',
  'symfony/config' => 'v5.4.2@2e082dae50da563c639119b7b52347a2a3db4ba5',
  'symfony/console' => 'v5.2.14@ffc2722adb0983451855c794c4bc7818d3c65fa2',
  'symfony/dependency-injection' => 'v5.4.2@ba94559be9738d77cd29e24b5d81cf3b89b7d628',
  'symfony/deprecation-contracts' => 'v2.5.0@6f981ee24cf69ee7ce9736146d1c57c2780598a8',
  'symfony/doctrine-bridge' => 'v5.2.12@0212d2d1e17a3e7403475b76e26fc1f0f1add04b',
  'symfony/dotenv' => 'v5.2.14@12888c9c46ac750ec5c1381db5bf3d534e7d70cb',
  'symfony/error-handler' => 'v5.4.2@e0c0dd0f9d4120a20158fc9aec2367d07d38bc56',
  'symfony/event-dispatcher' => 'v5.4.0@27d39ae126352b9fa3be5e196ccf4617897be3eb',
  'symfony/event-dispatcher-contracts' => 'v2.5.0@66bea3b09be61613cd3b4043a65a8ec48cfa6d2a',
  'symfony/expression-language' => 'v5.2.12@d4367d36217dd395b10f61649a6bf2c1367140d8',
  'symfony/filesystem' => 'v5.4.0@731f917dc31edcffec2c6a777f3698c33bea8f01',
  'symfony/finder' => 'v5.4.2@e77046c252be48c48a40816187ed527703c8f76c',
  'symfony/flex' => 'v1.17.6@7a79135e1dc66b30042b4d968ecba0908f9374bc',
  'symfony/framework-bundle' => 'v5.2.12@4e9ca1c60dba3b5e261eadd3b427bc115914b72b',
  'symfony/http-client-contracts' => 'v2.5.0@ec82e57b5b714dbb69300d348bd840b345e24166',
  'symfony/http-foundation' => 'v5.2.14@2a247de56fc8f5efdf1e098192128e8e509d370c',
  'symfony/http-kernel' => 'v5.2.14@2c3b9af1047c477c527504a3509ab59e4fae0689',
  'symfony/monolog-bridge' => 'v5.2.12@2c3943d7c0100983f9c0a82807555273353e3539',
  'symfony/monolog-bundle' => 'v3.7.1@fde12fc628162787a4e53877abadc30047fd868b',
  'symfony/options-resolver' => 'v5.2.12@1935d2e5329aba28cbb9ef6cc5687d007619d96d',
  'symfony/polyfill-ctype' => 'v1.23.0@46cd95797e9df938fdd2b03693b5fca5e64b01ce',
  'symfony/polyfill-iconv' => 'v1.23.0@63b5bb7db83e5673936d6e3b8b3e022ff6474933',
  'symfony/polyfill-intl-grapheme' => 'v1.23.1@16880ba9c5ebe3642d1995ab866db29270b36535',
  'symfony/polyfill-intl-normalizer' => 'v1.23.0@8590a5f561694770bdcd3f9b5c69dde6945028e8',
  'symfony/polyfill-mbstring' => 'v1.23.1@9174a3d80210dca8daa7f31fec659150bbeabfc6',
  'symfony/polyfill-php72' => 'v1.23.0@9a142215a36a3888e30d0a9eeea9766764e96976',
  'symfony/polyfill-php73' => 'v1.23.0@fba8933c384d6476ab14fb7b8526e5287ca7e010',
  'symfony/polyfill-php80' => 'v1.23.1@1100343ed1a92e3a38f9ae122fc0eb21602547be',
  'symfony/polyfill-php81' => 'v1.23.0@e66119f3de95efc359483f810c4c3e6436279436',
  'symfony/process' => 'v5.4.2@2b3ba8722c4aaf3e88011be5e7f48710088fb5e4',
  'symfony/property-access' => 'v5.2.12@82c6db3e4066ebc1993c377ae71090d0c8f0552c',
  'symfony/property-info' => 'v5.2.12@f9dd1886f47db8ea494d97a4b8bfa494094f53f1',
  'symfony/proxy-manager-bridge' => 'v5.2.12@76e61f33f6a34a340bf6e02211214f466e8e1dba',
  'symfony/routing' => 'v5.4.0@9eeae93c32ca86746e5d38f3679e9569981038b1',
  'symfony/security-bundle' => 'v5.2.12@bc36546f36355d7c0b56b23c44786b36904f838d',
  'symfony/security-core' => 'v5.2.14@4ce2b1e532fb3bb591ad4efa8cc43afc9242a247',
  'symfony/security-csrf' => 'v5.2.12@f0af6689451582e55f6b3439362e72e536e916e4',
  'symfony/security-guard' => 'v5.2.12@9edddb0b4c97eb923ba9910050be80f539933c3b',
  'symfony/security-http' => 'v5.2.12@8d6fb4fb1bb0d4a11b30de85cbf77914c71175bc',
  'symfony/serializer' => 'v5.2.12@3c3afcc285c01c486d1c5504e7895026580495c4',
  'symfony/service-contracts' => 'v2.5.0@1ab11b933cd6bc5464b08e81e2c5b07dec58b0fc',
  'symfony/stopwatch' => 'v5.2.12@24744393b122b8309bbcc7965972ae51a29a602d',
  'symfony/string' => 'v5.4.2@e6a5d5ecf6589c5247d18e0e74e30b11dfd51a3d',
  'symfony/translation' => 'v5.3.13@6ef0582a7a30141346ecc4541c9f61347b9f944b',
  'symfony/translation-contracts' => 'v2.5.0@d28150f0f44ce854e942b671fc2620a98aae1b1e',
  'symfony/twig-bridge' => 'v5.2.12@243a7c6416fea3b91391f09831d8d04b2e42c0b1',
  'symfony/twig-bundle' => 'v5.2.12@6f2aa369c4b7da19b3c864c48e35b26451c92e4e',
  'symfony/validator' => 'v5.2.14@a46ac85624ad3418d455bb8f4ce452014c28518c',
  'symfony/var-dumper' => 'v5.4.2@1b56c32c3679002b3a42384a580e16e2600f41c1',
  'symfony/var-exporter' => 'v5.4.2@2360c8525815b8535caac27cbc1994e2fa8644ba',
  'symfony/web-link' => 'v5.2.12@3d1f4a0318314c63c363f5d49de15d54780b2079',
  'symfony/yaml' => 'v5.2.14@ffe9c92e1a6c77c3ad5fc3a2ac16f0b8549dae10',
  'tecnickcom/tcpdf' => '6.4.4@42cd0f9786af7e5db4fcedaa66f717b0d0032320',
  'tedivm/jshrink' => 'v1.4.0@0513ba1407b1f235518a939455855e6952a48bbc',
  'tinymce/tinymce' => '5.10.4@3d7c8922e49e296c5d6b8d6d2873a44a57eb67d0',
  'tuupola/slim-jwt-auth' => '2.4.0@bca54de41a8207d4d67faf3601a06a96cb7ed48f',
  'twig/twig' => 'v3.3.7@8f168c6ffa3ce76d1786b3cd52275424a3fc675b',
  'vlucas/phpdotenv' => 'v3.6.10@5b547cdb25825f10251370f57ba5d9d924e6f68e',
  'voku/anti-xss' => '4.1.35@4d7ec2816cd6eeebb7d5abbde8b0349f66709496',
  'voku/portable-ascii' => '1.5.6@80953678b19901e5165c56752d087fc11526017c',
  'voku/portable-utf8' => '6.0.0@ac7596df7286649c08030746d1f2463aa89108a0',
  'webmozart/assert' => '1.10.0@6964c76c7804814a842473e0c8fd15bab0f18e25',
  'webonyx/graphql-php' => 'v0.13.9@d9a94fddcad0a35d4bced212b8a44ad1bc59bdf3',
  'wikimedia/composer-merge-plugin' => 'v2.0.1@8ca2ed8ab97c8ebce6b39d9943e9909bb4f18912',
  'willdurand/negotiation' => '3.0.0@04e14f38d4edfcc974114a07d2777d90c98f3d9c',
  'zbateson/mail-mime-parser' => '1.3.3@244b70963945293b5225da2553239a06987d1a11',
  'zbateson/mb-wrapper' => '1.1.1@bfd45fb3e2a8cf4c496b2c3ebd63b5f815721498',
  'zbateson/stream-decorators' => '1.0.6@3403c4323bd1cd15fe54348b031b26b064c706af',
  'zf1/zend-cache' => '1.12.20@c3a6fc20f5d5c5ab7adc16f29f33eb5b2e00d86e',
  'zf1/zend-crypt' => '1.12.20@15dea4f94fe90d0e0a9129770d57eefcd0672187',
  'zf1/zend-exception' => '1.12.20@ca30959d3e2f522f481a3d1459386acf1aa4ca74',
  'zf1/zend-gdata' => '1.12.20@f9d9878c82743fa7e2d5b07247ea684af5acd047',
  'zf1/zend-http' => '1.12.20@de1e836ea1bc7d5acccc82b1cf4dd236271a21cb',
  'zf1/zend-loader' => '1.12.20@894dcfb8084488575d46e496e399f64aacd5761c',
  'zf1/zend-locale' => '1.12.20@336df96aebb0270fb682e6ee8bf0cc0781cc3edb',
  'zf1/zend-mime' => '1.12.20@1ad54a9851dadfb0b1dc67268baf0db4fb0112b0',
  'zf1/zend-oauth' => '1.12.20@4378ade6a8e2606d55b7e3183e58e65452c0c65c',
  'zf1/zend-registry' => '1.12.20@1737419285b800728c27063318509fb2d00057ba',
  'zf1/zend-uri' => '1.12.20@73964522a8a5041798cc8edad1e81fa0879737f2',
  'zf1/zend-validate' => '1.12.20@5ceb707212abaaf92ccdd91270c6d37e07bf551b',
  'zf1/zend-version' => '1.12.20@8e69ac4b262482e3980012d7be4a35a89f76da63',
  'zf1/zend-xml' => '1.12.20@d4f99144a0cf0c5e383f3fb765cdd7dfde7caab4',
  'salesagility/suitecrm' => 'dev-release/8.1.3@1a2a52d2f2b3d10ea9f96f6dab1a7acd9186a246',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === []) {
                return false;
            }
        }

        return true;
    }
}
